/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.justverticalslabs.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import crystalspider.justverticalslabs.blocks.VerticalSlabBlock;
import crystalspider.justverticalslabs.blocks.VerticalSlabBlockEntity;
import crystalspider.justverticalslabs.utils.VerticalSlabUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class VerticalSlabLootModifier
extends LootModifier {
    public static final Supplier<Codec<VerticalSlabLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> VerticalSlabLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, VerticalSlabLootModifier::new)));

    public VerticalSlabLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.m_78953_(LootContextParams.f_81462_) instanceof VerticalSlabBlockEntity) {
            ObjectArrayList loot = new ObjectArrayList();
            for (ItemStack itemStack : generatedLoot) {
                BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState(itemStack);
                if (referredSlabState == null) continue;
                LootTable referredLootTable = context.m_78952_().m_7654_().m_129898_().m_79217_(referredSlabState.m_60734_().m_60589_());
                LootContext.Builder builder = new LootContext.Builder(context).m_78984_(LootContextParams.f_81462_, null).m_78972_(LootContextParams.f_81461_, (Object)referredSlabState);
                for (ItemStack slabLoot : referredLootTable.m_230922_(builder.m_78975_(LootContextParamSets.f_81421_))) {
                    BlockState verticalSlaBlockState;
                    Item itemLoot = slabLoot.m_41720_();
                    if (VerticalSlabUtils.MapsManager.slabStateMap.containsKey((Object)itemLoot)) {
                        loot.add((Object)VerticalSlabUtils.getVerticalSlabItem((BlockState)VerticalSlabUtils.MapsManager.slabStateMap.get((Object)itemLoot), VerticalSlabUtils.isTranslucent(itemLoot)));
                    } else {
                        loot.add((Object)slabLoot);
                    }
                    if ((verticalSlaBlockState = (BlockState)context.m_78953_(LootContextParams.f_81461_)) == null || !((Boolean)verticalSlaBlockState.m_61143_((Property)VerticalSlabBlock.DOUBLE)).booleanValue()) continue;
                    for (ItemStack itemStackLoot : loot) {
                        itemStackLoot.m_41764_(itemStackLoot.m_41613_() * 2);
                    }
                }
            }
            return loot;
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

